document.addEventListener("DOMContentLoaded", () => {
    fetch('../php/main.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Dynamically update the welcome message
                document.getElementById('welcome-message').textContent = `Laipni lūdzam, ${data.first_name} ${data.last_name}!`;
            } else {
                console.error(data.message); // Log the error for debugging
            }
        })
        .catch(err => console.error("Failed to fetch user data:", err));
});